# AI Coding Agent Guide — Perfex Workshop Module

This is a Perfex CRM module (CodeIgniter 3) named `workshop` for managing repair jobs, inspections, devices, mechanics, branches, and related assets.

## Big Picture
- Entry: `workshop.php` — defines constants, registers hooks/menus/permissions, loads helpers, runs `install.php` on activation to create `wshop_*` tables.
- MVC: controllers (`controllers/Workshop.php` admin, `controllers/Client.php` client, `controllers/Gtsverify.php` verification), model (`models/Workshop_model.php` DB/business logic, numbering, barcode/QR, uploads), views (`views/**` including PDFs and DataTables).
- Assets: `assets/js/**` (per‑feature PHP JS using Perfex globals like `admin_url`, `_l()`), `assets/css/**`.
- Language: `language/*/workshop_lang.php` with keys prefixed `wshop_*` (English is baseline).

## Runtime & Integration
- Install under `modules/workshop` in a Perfex instance; activate in Admin → Setup → Modules (triggers activation hook → `install.php`).
- Hooks: admin head/footer injectors, sidebar/customers navigation, tasks relations, permissions via `workshop_permissions()`.
- Upload roots/constants from `workshop.php`: `MANUFACTURER_IMAGES_FOLDER`, `DEVICES_IMAGES_FOLDER`, `WORKSHOP_FOLDER`, `INSPECTION_FOLDER`, `INSPECTION_QUESTION_FOLDER`, `NOTE_FOLDER`, `TRANSACTION_FOLDER`, `REPAIR_JOB_BARCODE`, `REPAIR_JOB_QR_FOLDER` (+ `*_UPLOAD_PATH`).
- Licensing/verify: `controllers/Gtsverify.php`, `libraries/gtsslib.php`, token files under `libraries/lictoken/`.

## Conventions & Patterns
- Permissions: check with `has_permission('workshop_area','', 'action')` or `is_admin()`; keep controllers returning early on `access_denied`.
- Language: use `_l('wshop_key')`; add keys to all `language/*/workshop_lang.php`.
- Server responses: Non‑AJAX → `set_alert()` + `redirect()`; AJAX → `echo json_encode(['success'=>bool,'message'=>str]); die;`.
- DataTables: `$this->app->get_table_data(module_views_path('workshop','<table_view>'))`; tables under `views/..._table.php`; page JS at `assets/js/<feature>/*_js.php` (auto‑included via hooks).
- Uploads: use helpers (`handle_*`, `_maybe_create_upload_path`, `unique_filename`, `create_img_thumb`); follow per‑entity folders; delete via `delete_dir()`; never hardcode absolute paths—use constants.
- Numbering/prefix: options like `wshop_repair_job_prefix` via `add_option/update_option`; update counters in `Workshop_model::update_prefix_number()`.

## Key Flows
- Settings tabs: `Workshop::setting()` maps `group` to `views/settings/<group>.php`. Add to `$data['tab'][]`, set `$data['tabs']['view']`, create view + CSS/JS (wire via `workshop_load_js()`).
- Repair job detail: `Workshop::repair_job_detail` and `Client::repair_job_detail` load job/device/taxes/attachments; barcode ensured by `Workshop_model::getBarcode()` into `REPAIR_JOB_BARCODE`. PDFs live in `libraries/pdf/*.php` and `views/repair_jobs/print_*`.
- File preview: `Client::preview_file()` resolves folder by `rel_type` constant and renders `views/returns/preview_pdf_file`.

## Developer Workflow
- Local run: install Perfex CRM; copy/symlink to `modules/workshop`; ensure `uploads/**` writable by PHP.
- Debugging: enable Perfex/CI logging; inspect AJAX JSON; review schema created by `install.php`.
- Extending UI: add CSS via `workshop_add_head_components()`; add per‑page JS via `workshop_load_js()` (JS files are PHP to access `_l()` and `admin_url`).

## References
- Entry/hooks: `workshop.php`; controllers: `controllers/Workshop.php`, `controllers/Client.php`; model: `models/Workshop_model.php`.
- Helpers: `helpers/workshop_helper.php`, `helpers/workshop_inspection_helper.php`, `helpers/workshop_inspection_template_helper.php`.
- Assets: `assets/js/**`, `assets/css/**`; Language baseline: `language/english/workshop_lang.php`.
